import { Link, useLocation } from 'react-router-dom'
import { ChefHat } from 'lucide-react'
import './Header.css'

function Header() {
  const location = useLocation()
  
  return (
    <header className="header">
      <div className="container">
        <div className="header-content">
          <Link to="/" className="logo">
            <ChefHat className="logo-icon" size={32} />
            <span className="logo-text">КулинарМастер</span>
          </Link>
          <nav className="nav">
            <Link 
              to="/" 
              className={`nav-link ${location.pathname === '/' ? 'active' : ''}`}
            >
              Мои участия
            </Link>
            <Link 
              to="/book" 
              className={`nav-link ${location.pathname === '/book' ? 'active' : ''}`}
            >
              Записаться
            </Link>
          </nav>
        </div>
      </div>
    </header>
  )
}

export default Header

